<?php
session_start();
require_once 'config.php';
?>
<!doctype html>
<html class="no-js" lang="zxx">
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>About Us - Cleaning Service</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="shortcut icon" href="assets/img/favicon.ico" type="image/x-icon">
    <link rel="icon" href="assets/img/favicon.ico" type="image/x-icon">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link href="../../css2-2?family=Fuzzy+Bubbles:wght@400;700&family=Poppins:wght@400;500;600;700;800&family=Rubik:ital,wght@0,300..900;1,300..900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
    <link rel="stylesheet" href="assets/css/slick.min.css">
    <link rel="stylesheet" href="assets/css/animate.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        .vs-header .sticky-wrapper {
            position: sticky;
            top: 0;
            z-index: 1030;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            animation: slideDown 0.3s ease-in-out;
        }
        @keyframes slideDown {
            from { transform: translateY(-100%); opacity: 0; }
            to { transform: translateY(0); opacity: 1; }
        }
        .auth-buttons { display: flex; gap: clamp(8px, 1.5vw, 16px); align-items: center; flex-wrap: wrap; }
        .auth-btn { padding: clamp(8px, 1.2vw, 14px) clamp(12px, 2vw, 18px); border: 2px solid transparent; border-radius: 8px; font-size: clamp(12px, 1.5vw, 16px); font-weight: 600; cursor: pointer; transition: all 0.3s ease; display: flex; align-items: center; gap: 6px; white-space: nowrap; background: transparent; }
        .login-btn { color: #109c3d; border-color: #109c3d; }
        .login-btn:hover { background: #109c3d; color: #ffffff; transform: translateY(-2px); box-shadow: 0 4px 12px rgba(16, 156, 61, 0.3); }
        .register-btn { background: #109c3d; color: #ffffff; border-color: #109c3d; }
        .register-btn:hover { background: linear-gradient(135deg, #0f8c3d, #109c3d); transform: translateY(-2px); box-shadow: 0 4px 12px rgba(16, 156, 61, 0.4); }
        @media (max-width: 991px) { .auth-buttons { display: none; } }
    </style>
</head>
<body>
    <!-- <div class="preloader">
        <button class="vs-btn preloaderCls">Cancel Preloader</button>
        <div class="preloader-inner">
            <img src="assets/img/logo.svg" alt="logo">
            <span class="loader"></span>
        </div>
    </div> -->

    <!-- Include Header -->
    <?php include 'header.php'; ?>

    <!-- Main Content -->
    <div class="breadcumb-wrapper " data-bg-src="assets/img/breadcumb/breadcumb-bg.png">
            <div class="container z-index-common">
                <div class="breadcumb-content">
                    <h1 class="breadcumb-title">About <span>Us</span></h1>
                </div>
                <div class="breadcumb-menu-wrap">
                    <ul class="breadcumb-menu">
                        <li><a href="index.php">Home</a></li>
                        <li>about us</li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- About Area  -->
          <section class="about-layout1 space-top">
            <style>
                /* ===============================
   ABOUT SECTION – RESPONSIVE
================================ */

.about-layout1 {
    padding: 80px 0;
}

.img-box1 {
    position: relative;
    display: flex;
    justify-content: center;
}

.img-box1 img {
    width: 100%;
    border-radius: 18px;
}

.img1 {
    width: 75%;
}

.img2 {
    position: absolute;
    width: 55%;
    right: -30px;
    bottom: -30px;
}

.img-icon {
    position: absolute;
    top: -20px;
    left: -20px;
    z-index: 2;
}

/* CONTENT */
.about-content {
    max-width: 560px;
}

.sec-subtitle {
    display: inline-block;
    font-size: 14px;
    font-weight: 600;
    letter-spacing: 2px;
    color: #4facfe;
    margin-bottom: 10px;
}

.sec-title {
    font-size: 36px;
    font-weight: 800;
    line-height: 1.2;
    margin-bottom: 15px;
}

.title-highlight {
    color: #4facfe;
}

.about-text {
    font-size: 16px;
    line-height: 1.7;
    margin-bottom: 30px;
}

/* FEATURE BOX */
.about-box1 {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 20px;
    margin-bottom: 30px;
}

.about-item {
    background: #fff;
    padding: 22px;
    border-radius: 16px;
    box-shadow: 0 12px 30px rgba(0,0,0,0.08);
}

.about-inner {
    display: flex;
    align-items: center;
    gap: 25px;
    flex-wrap: wrap;
}

.author-box {
    display: flex;
    align-items: center;
    gap: 12px;
}

.author-box img {
    width: 55px;
    height: 55px;
    border-radius: 50%;
}

/* NOTICE */
.about-notice {
    display: flex;
    align-items: center;
    gap: 12px;
    margin-top: 25px;
}

/* ===============================
   TABLET
================================ */
@media (max-width: 991px) {
    .about-layout1 {
        padding: 60px 0;
    }

    .img-box1 {
        margin-bottom: 40px;
    }

    .about-box1 {
        grid-template-columns: 1fr;
    }

    .img2 {
        right: -15px;
        bottom: -15px;
    }
}

/* ===============================
   MOBILE
================================ */
@media (max-width: 576px) {

    .sec-title {
        font-size: 26px;
    }

    .img2 {
        position: static;
        width: 100%;
        margin-top: 20px;
    }

    .about-inner {
        flex-direction: column;
        align-items: flex-start;
    }

    .about-notice {
        flex-direction: column;
        text-align: center;
    }
}

            </style>
         <div class="container">
        <div class="row gx-60 g-5 align-items-center justify-content-center">

            <!-- IMAGE COLUMN -->
            <div class="col-xl-6 col-lg-6">
                <div class="img-box1">
                    
                    <div class="img1">
                        <img src="assets/img/about/about-img-1-1.jpg" alt="Professional Cleaning">
                    </div>

                    <div class="img2">
                        <img src="assets/img/about/about-img-1-2.jpg" alt="Expert Team Cleaning">
                    </div>
                </div>
            </div>

            <!-- CONTENT COLUMN -->
            <div class="col-xl-6 col-lg-6">
                <div class="about-content">

                    <span class="sec-subtitle">ABOUT OUR COMPANY</span>
                    <h2 class="sec-title">
                        Trusted <span class="title-highlight">Cleaning Experts</span> in Your City
                    </h2>

                    <p class="about-text">
                        We provide reliable and affordable cleaning services designed to give your home
                        a fresh, healthy, and spotless environment. Our trained professionals ensure
                        top-quality service every time.
                    </p>

                    <div class="about-box1">
                        <div class="about-item">
                            <span class="item-icon">
                                <img src="assets/img/icon/about-icon2.svg" alt="icon">
                            </span>
                            <h3 class="item-title">Home Cleaning</h3>
                            <p class="item-text">
                                Complete cleaning solutions for bedrooms, kitchens, and bathrooms.
                            </p>
                        </div>

                        <div class="about-item">
                            <span class="item-icon">
                                <img src="assets/img/icon/about-icon3.svg" alt="icon">
                            </span>
                            <h3 class="item-title">Living Area Care</h3>
                            <p class="item-text">
                                Deep cleaning for living rooms, sofas, carpets, and common areas.
                            </p>
                        </div>
                    </div>

                    <div class="about-inner">
                        <a class="vs-btn2" href="about.php">
                            Learn More <i class="far fa-long-arrow-right"></i>
                        </a>

                        <div class="author-box">
                            <img src="assets/img/about/author-img.jpg" alt="Founder">
                            <div class="author-content">
                                <h4 class="title">David Markwin</h4>
                                <span class="desi">Founder & Director</span>
                            </div>
                        </div>
                    </div>

                    <div class="about-notice">
                        <span class="notice-icon">
                            <img src="assets/img/icon/about-icon4.svg" alt="icon">
                        </span>
                        <p class="notice-text">
                            Professional deep cleaning for a healthier and happier home.
                        </p>
                    </div>

                </div>
            </div>

        </div>
    </div>
</section>
        <!-- About Area End -->

        <section class="package-layout1 space">
            <style>
                /* =====================================
   PRICING – UNIQUE ATTRACTIVE DESIGN
===================================== */

.package-layout1 {
    position: relative;
    padding-top:90px;
    padding-bottom:20px;
    background-size: cover;
    background-position: center;
    overflow: hidden;
}

/* DARK GRADIENT OVERLAY */
.package-layout1::before {
    content: "";
    position: absolute;
    inset: 0;
    background: radial-gradient(
        circle at top,
        rgba(79,172,254,0.35),
        rgba(5,10,30,0.9)
    );
    z-index: 0;
}

.package-layout1 .container {
    position: relative;
    z-index: 1;
    margin-top: -77px;
}

/* =====================================
   GRID – CLEAN & BALANCED
===================================== */

.package-layout1 .row.g-5 {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(290px, 1fr));
    gap: clamp(22px, 3vw, 45px);
}

.package-layout1 .row.g-5 > [class*="col-"] {
    width: 100%;
    max-width: 100%;
}

/* =====================================
   CARD – PREMIUM LOOK
===================================== */

.package-style1 {
    height: 100%;
    display: flex;
    flex-direction: column;
    background: linear-gradient(
        180deg,
        #ffffff,
        #f9fbff
    );
    border-radius: 28px;
    position: relative;
    box-shadow:
        0 10px 30px rgba(0,0,0,0.15),
        inset 0 0 0 1px rgba(255,255,255,0.6);
    transition: transform 0.4s ease, box-shadow 0.4s ease;
}

/* CARD GLOW */
.package-style1::after {
    content: "";
    position: absolute;
    inset: -2px;
    border-radius: inherit;
    background: linear-gradient(
        120deg,
        transparent,
        rgba(79,172,254,0.6),
        transparent
    );
    opacity: 0;
    transition: opacity 0.4s ease;
    pointer-events: none;
}

.package-style1:hover::after {
    opacity: 1;
}

/* LIFT ON HOVER */
.package-style1:hover {
    transform: translateY(-14px) scale(1.02);
    box-shadow: 0 45px 100px rgba(0,0,0,0.25);
}

/* =====================================
   HEADER
===================================== */

.package-top {
    padding: clamp(24px, 3vw, 34px);
    border-bottom: 1px solid rgba(0,0,0,0.08);
}

.package-name {
    font-size: clamp(18px, 1.8vw, 22px);
    font-weight: 800;
    letter-spacing: 0.3px;
    text-transform: capitalize;
}

.package-text {
    font-size: 14px;
    color: #64748b;
}

/* =====================================
   PRICE – VISUAL FOCUS
===================================== */

.package-price {
    margin-top: 14px;
    font-size: clamp(36px, 3.5vw, 46px);
    font-weight: 900;
    color: #0f172a;
    position: relative;
}

.package-price::after {
    content: "";
    position: absolute;
    left: 0;
    bottom: -8px;
    width: 42px;
    height: 4px;
    border-radius: 10px;
    background: linear-gradient(90deg, #4facfe, #00f2fe);
}

/* =====================================
   BODY
===================================== */

.package-body {
    padding: 0px;
    flex: 1;
}

.list-style1 li {
    font-size: 15px;
    line-height: 1.6;
    margin-bottom: 12px;
    display: flex;
    align-items: flex-start;
    gap: 10px;
}

/* =====================================
   FOOTER
===================================== */

.package-bottom {
    padding: 22px 30px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.save-price {
    font-weight: 700;
    color: #16a34a;
}

/* CTA BUTTON */
.price-btn {
    padding: 26px;
}

.price-btn .vs-btn2 {
    width: 100%;
    font-size: 16px;
    padding: 5px;
    border-radius: 14px;
    background: linear-gradient(135deg, #4facfe, #00f2fe);
    box-shadow: 0 15px 35px rgba(79,172,254,0.45);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.price-btn .vs-btn2:hover {
    transform: translateY(-2px);
    box-shadow: 0 25px 50px rgba(79,172,254,0.6);
}

/* =====================================
   MOBILE POLISH
===================================== */

@media (max-width: 576px) {

    .package-style1 {
        text-align: center;
    }

    .package-inner,
    .package-bottom {
        flex-direction: column;
        gap: 12px;
    }

    .package-price::after {
        left: 50%;
        transform: translateX(-50%);
    }
}

/* =====================================
   ULTRA WIDE SCREENS
===================================== */

@media (min-width: 1600px) {
    .package-layout1 {
        padding: 180px 0;
    }
}

            </style>
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-6">
                        <div class="title-area text-center wow animate__fadeInUp title-anime animation-style5" data-wow-delay="0.25s">
                            <span class="sec-subtitle justify-content-center title-anime__title">OUR PRICING</span>
                            <h2 class="sec-title title-anime__title text-white">Choose Your Pricing</h2>
                        </div>
                    </div>
                </div>              
                <div class="row g-5">
                    <div class="col-xl-4 col-md-6 wow animate__fadeInUp" data-wow-delay="0.25s">
                        <div class="package-wraper">
                            <div class="package-style1">
                                <div class="package-top">
                                    <div class="package-inner">
                                        <div class="title-area">
                                            <h3 class="package-name">home plan</h3>
                                            <p class="package-text">starter plan</p>
                                        </div>
                                        <div class="package-icon">
                                            <div class="icon-btn3"> <span class="icon"><img src="assets/img/icon/service-icon-3-2.svg" alt="service-icon"></span></div>
                                        </div>
                                    </div>
                                    <p class="package-price"><i class="fa-light fa-dollar-sign"></i>29<span class="duration">/month</span></p>
                                </div>
                                <div class="package-body">                                   
                                    <div class="list-style1">
                                        <ul class="list-unstyled mb-0">
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">100 % Satisfaction Guarante</li>
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">Clean all mirrors</li>
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">Dining & Living Room</li>
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">cleaning  your home will soon</li>
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">Bed & Mattress Cleaning</li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="package-bottom">
                                    <span class="save-price">save <strong>$20</strong></span>
                                    <div class="star-rating">
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                    </div>
                                </div>
                                <div class="price-btn">
                                    <a class="vs-btn2" href="contact.php">Book Now<i class="far fa-long-arrow-right"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4 col-md-6 wow animate__fadeInUp" data-wow-delay="0.45s">
                        <div class="package-wraper">
                            <div class="package-style1">
                                <div class="package-top">
                                    <div class="package-inner">
                                        <div class="title-area">
                                            <h3 class="package-name">office plan</h3>
                                            <p class="package-text">home service</p>
                                        </div>
                                        <div class="package-icon">
                                            <div class="icon-btn3"> <span class="icon"><img src="assets/img/icon/service-icon-2-5.svg" alt="service-icon"></span></div>
                                        </div>
                                    </div>
                                    <p class="package-price"><i class="fa-light fa-dollar-sign"></i>45<span class="duration">/month</span></p>
                                </div>
                                <div class="package-body">                                   
                                    <div class="list-style1">
                                        <ul class="list-unstyled mb-0">
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">100 % Satisfaction Guarante</li>
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">Clean all mirrors</li>
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">Dining & Living Room</li>
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">cleaning  your home will soon</li>
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">Bed & Mattress Cleaning</li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="package-bottom">
                                    <span class="save-price">save <strong>$20</strong></span>
                                    <div class="star-rating">
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                    </div>
                                </div>
                                <div class="price-btn">
                                    <a class="vs-btn2" href="contact.php">Book Now<i class="far fa-long-arrow-right"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4 col-md-6 wow animate__fadeInUp" data-wow-delay="0.65s">
                        <div class="package-wraper">
                            <div class="package-style1">
                                <div class="package-top">
                                    <div class="package-inner">
                                        <div class="title-area">
                                            <h3 class="package-name">apartment plan</h3>
                                            <p class="package-text">home service</p>
                                        </div>
                                        <div class="package-icon">
                                            <div class="icon-btn3"> <span class="icon"><img src="assets/img/icon/service-icon-2-6.svg" alt="service-icon"></span></div>
                                        </div>
                                    </div>
                                    <p class="package-price"><i class="fa-light fa-dollar-sign"></i>55<span class="duration">/month</span></p>
                                </div>
                                <div class="package-body">                                   
                                    <div class="list-style1">
                                        <ul class="list-unstyled mb-0">
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">100 % Satisfaction Guarante</li>
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">Clean all mirrors</li>
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">Dining & Living Room</li>
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">cleaning  your home will soon</li>
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">Bed & Mattress Cleaning</li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="package-bottom">
                                    <span class="save-price">save <strong>$20</strong></span>
                                    <div class="star-rating">
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                    </div>
                                </div>
                                <div class="price-btn">
                                    <a class="vs-btn2" href="contact.php">Book Now<i class="far fa-long-arrow-right"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="common-line shape-mockup d-none d-lg-block" style="top: -9px;">
                <img src="assets/img/shapes/line-shep.png" alt="shapes">
            </div>
        </section>

        <section class="about-section">
    <div class="container">

        <div class="about-header">
            <h2>About Our Cleaning Services</h2>
            <p>
                We provide professional, reliable, and eco-friendly cleaning services
                for homes and businesses. Our mission is to create clean, healthy,
                and comfortable spaces for our customers.
            </p>
        </div>

        <div class="services-grid">

            <div class="service-card">
                <div class="icon">🏠</div>
                <h3>Residential Cleaning</h3>
                <p>
                    Complete home cleaning including kitchen, bathroom,
                    floor mopping, dusting, and sanitization.
                </p>
            </div>

            <div class="service-card">
                <div class="icon">🏢</div>
                <h3>Commercial Cleaning</h3>
                <p>
                    Professional office and workspace cleaning to
                    maintain hygiene and productivity.
                </p>
            </div>

            <div class="service-card">
                <div class="icon">🧽</div>
                <h3>Deep Cleaning</h3>
                <p>
                    Deep sanitization removing bacteria, grease,
                    stains, and hidden dust from all areas.
                </p>
            </div>

            <div class="service-card">
                <div class="icon">🌿</div>
                <h3>Eco-Friendly Cleaning</h3>
                <p>
                    Safe, non-toxic cleaning products that protect
                    your health and environment.
                </p>
            </div>

        </div>
    </div>
    <style>
        .about-section{
padding-top:30px;
padding-bottom:2%0px;
background:#f8fafc;
}

.container{
max-width:1200px;
margin:auto;
}

.about-header{
text-align:center;
margin-bottom:50px;
}

.about-header h2{
font-size: clamp(28px, 4vw, 40px);
color:#0f172a;
margin-bottom:15px;
}

.about-header p{
max-width:700px;
margin:auto;
color:#475569;
font-size:16px;
line-height:1.6;
}

.services-grid{
display:grid;
grid-template-columns: repeat(4,1fr);
gap:25px;
}

.service-card{
background:white;
padding:30px;
border-radius:14px;
box-shadow:0 8px 20px rgba(0,0,0,0.06);
transition:0.3s;
text-align:center;
}

.service-card:hover{
transform: translateY(-6px);
}

.icon{
font-size:32px;
margin-bottom:15px;
}

.service-card h3{
margin-bottom:10px;
color:#0f172a;
}

.service-card p{
color:#64748b;
font-size:15px;
line-height:1.5;
}

/* RESPONSIVE */
@media(max-width:992px){
.services-grid{
grid-template-columns: repeat(2,1fr);
}
}

@media(max-width:576px){
.services-grid{
grid-template-columns: 1fr;
}
}

    </style>
</section>

        <!-- Client Area  -->
         <section class="vs-client__layout1 space-bottom">
            <style>
                /* =====================================
   CLIENT / TRUSTED SERVICE – UNIQUE UI
===================================== */

.vs-client__layout1 {
    position: relative;
    padding: clamp(70px, 9vw, 160px) 0;
    background-size: cover;
    background-position: center;
    overflow: hidden;
}

/* DARK OVERLAY FOR CONTRAST */
.vs-client__layout1::before {
    content: "";
    position: absolute;
    inset: 0;
    background: linear-gradient(
        180deg,
        rgba(5,10,30,0.85),
        rgba(5,10,30,0.95)
    );
    z-index: 0;
}

.vs-client__layout1 > .container {
    position: relative;
    z-index: 1;
}

/* =====================================
   VIDEO CTA BOX
===================================== */

.video-style1 {
    padding: clamp(60px, 6vw, 100px) 20px;
    border-radius: 30px;
    background-size: cover;
    background-position: center;
    margin-bottom: clamp(50px, 7vw, 90px);
    box-shadow: 0 35px 90px rgba(0,0,0,0.35);
}

.video-area {
    margin-bottom: 25px;
}

/* PLAY BUTTON */
.video-style1 .play-btn {
    width: 86px;
    height: 86px;
    background: linear-gradient(135deg, #4facfe, #00f2fe);
    color: #fff;
    border-radius: 50%;
    font-size: 28px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 25px 60px rgba(79,172,254,0.55);
    transition: transform 0.3s ease;
}

.video-style1 .play-btn:hover {
    transform: scale(1.12);
}

/* CTA TITLE */
.video-style1 .sec-title {
    color: #fff;
    font-size: clamp(26px, 3vw, 40px);
    margin-bottom: 18px;
}

/* =====================================
   LEFT CONTENT (TRUST)
===================================== */

.vs-client__inner {
    display: flex;
    align-items: center;
    gap: 18px;
    margin-top: 25px;
}

.author-img img {
    width: clamp(70px, 7vw, 110px);
}

.vs-client__content {
    background: rgba(255,255,255,0.12);
    backdrop-filter: blur(8px);
    padding: 18px 26px;
    border-radius: 20px;
    color: #fff;
    text-align: center;
}

.vs-client__subtitle {
    font-size: clamp(28px, 3vw, 40px);
    font-weight: 900;
}

.vs-client__text {
    font-size: 14px;
    opacity: 0.85;
}

/* =====================================
   BRAND GRID
===================================== */

.vs-client__brand {
    height: 100%;
    background: rgba(255,255,255,0.92);
    border-radius: 18px;
    padding: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 18px 45px rgba(0,0,0,0.12);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.vs-client__brand img {
    max-width: 100%;
    max-height: 60px;
    object-fit: contain;
    filter: grayscale(100%);
    transition: filter 0.3s ease;
}

.vs-client__brand:hover {
    transform: translateY(-8px);
    box-shadow: 0 28px 70px rgba(0,0,0,0.18);
}

.vs-client__brand:hover img {
    filter: grayscale(0%);
}

/* =====================================
   MOBILE OPTIMIZATION
===================================== */

@media (max-width: 576px) {

    .video-style1 {
        padding: 50px 20px;
        text-align: center;
    }

    .vs-client__inner {
        flex-direction: column;
        text-align: center;
    }

    .vs-client__content {
        width: 100%;
    }
}

/* =====================================
   LARGE SCREENS
===================================== */

@media (min-width: 1600px) {
    .vs-client__layout1 {
        padding: 180px 0;
    }
}

            </style>
            
            <div class="container">
                <div class="row g-5">
                    <div class="col-xl-5 position-relative wow animate__fadeInUp">
                        <div class="title-area title-anime animation-style5">
                            <span class="sec-subtitle left-shape justify-content-center title-anime__title">ABOUT CLEANING</span>
                            <h2 class="sec-title text-white title-anime__title">Excellent <span class="title-highlight">Service</span> cleaning</h2>
                        </div>
                        <div class="vs-client__inner">
                            <div class="author-img">
                                <img src="assets/img/cleaning/cleaning-tumb-1.png" alt="cleaning tumb">
                            </div>
                            <div class="vs-client__content">
                                <span class="vs-client__subtitle">57+</span>
                                <p class="vs-client__text">Members</p>
                            </div>
                        </div>
                        <span class="shape-mockup vs-slider-shape-1  d-xl-block d-none" style="right: 35px; top: -35px;"><img src="assets/img/shapes/cleaning-shapes-1.png" alt="counter element"></span>
                    </div>
                    <div class="col-xl-7">
                        <div class="row gx-3 gy-3">
                            <div class="col-xl-4 col-6 col-md-4 wow animate__fadeInUp" data-wow-delay="0.25s">
                                <div class="vs-client__brand">
                                    <img src="assets/img/brand/brand-1.png" alt="Brand Images">
                                </div>
                            </div>
                            <div class="col-xl-4 col-6 col-md-4 wow animate__fadeInUp" data-wow-delay="0.35s">
                                <div class="vs-client__brand">
                                    <img src="assets/img/brand/brand-2.png" alt="Brand Images">
                                </div>
                            </div>
                            <div class="col-xl-4 col-6 col-md-4 wow animate__fadeInUp" data-wow-delay="0.45s">
                                <div class="vs-client__brand">
                                    <img src="assets/img/brand/brand-3.png" alt="Brand Images">
                                </div>
                            </div>
                            <div class="col-xl-4 col-6 col-md-4 wow animate__fadeInUp" data-wow-delay="0.65s">
                                <div class="vs-client__brand">
                                    <img src="assets/img/brand/brand-4.png" alt="Brand Images">
                                </div>
                            </div>
                            <div class="col-xl-4 col-6 col-md-4 wow animate__fadeInUp" data-wow-delay="0.75s">
                                <div class="vs-client__brand">
                                    <img src="assets/img/brand/brand-5.png" alt="Brand Images">
                                </div>
                            </div>
                            <div class="col-xl-4 col-6 col-md-4 wow animate__fadeInUp" data-wow-delay="0.85s">
                                <div class="vs-client__brand">
                                    <img src="assets/img/brand/brand-1.png" alt="Brand Images">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="common-line shape-mockup d-none d-xxl-block" style="top: -7px;">
                <img src="assets/img/shapes/line-shep.png" alt="shapes">
            </div>
         </section>
        <!-- Client Area End -->


       

    <!-- Include Footer -->
    <?php include 'footer.php'; ?>

    <script src="assets/js/vendor/jquery-3.7.1.min.js"></script>
    <script src="assets/js/slick.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/jquery.magnific-popup.min.js"></script>
    <script src="assets/js/imagesloaded.pkgd.min.js"></script>
    <script src="assets/js/gsap.min.js"></script>
    <script src="assets/js/ScrollTrigger.min.js"></script>
    <script src="assets/js/gsap-scroll-to-plugin.js"></script>
    <script src="assets/js/SplitText.js"></script>
    <script src="assets/js/lenis.min.js"></script>
    <script src="assets/js/wow.min.js"></script>
    <script src="assets/js/main.js"></script>
</body>
</html>
